

/*
 *
 * new Font
 *
 * created with FontCreator
 * written by F. Maximilian Thiele
 *
 * http://www.apetech.de/fontCreator
 * me@apetech.de
 *
 * File Name           : Brodway15.h
 * Date                : 15.03.2018
 * Font size in bytes  : 12177
 * Font width          : 10
 * Font height         : 15
 * Font first char     : 32
 * Font last char      : 128
 * Font used chars     : 96
 *
 * The font data are defined as
 *
 * struct _FONT_ {
 *     uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
 *     uint8_t    font_Width_in_Pixel_for_fixed_drawing;
 *     uint8_t    font_Height_in_Pixel_for_all_characters;
 *     unit8_t    font_First_Char;
 *     uint8_t    font_Char_Count;
 *
 *     uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
 *                  // for each character the separate width in pixels,
 *                  // characters < 128 have an implicit virtual right empty row
 *
 *     uint8_t    font_data[];
 *                  // bit field of all characters
 */

#include <inttypes.h>
#include <avr/pgmspace.h>

#ifndef BRODWAY15_H
#define BRODWAY15_H

#define BRODWAY15_WIDTH 10
#define BRODWAY15_HEIGHT 15

const static uint8_t Brodway15[] PROGMEM = {
    0x2F, 0x91, // size
    0x0A, // width
    0x0F, // height
    0x20, // first char
    0x60, // char count
    
    // char widths
    0x00, 0x05, 0x05, 0x09, 0x08, 0x0C, 0x0C, 0x02, 0x04, 0x04, 
    0x05, 0x09, 0x05, 0x06, 0x05, 0x07, 0x08, 0x07, 0x09, 0x09, 
    0x0A, 0x09, 0x08, 0x0A, 0x08, 0x08, 0x05, 0x05, 0x07, 0x09, 
    0x07, 0x08, 0x0B, 0x0D, 0x09, 0x0A, 0x0A, 0x0A, 0x09, 0x0A, 
    0x0A, 0x05, 0x09, 0x0B, 0x0A, 0x0F, 0x0A, 0x0A, 0x0A, 0x0A, 
    0x0A, 0x08, 0x0B, 0x0A, 0x0D, 0x10, 0x0C, 0x0C, 0x0B, 0x05, 
    0x07, 0x05, 0x08, 0x08, 0x04, 0x09, 0x0A, 0x07, 0x0A, 0x08, 
    0x06, 0x07, 0x0A, 0x04, 0x05, 0x0B, 0x04, 0x10, 0x0A, 0x08, 
    0x0A, 0x0A, 0x07, 0x08, 0x07, 0x0A, 0x0A, 0x0E, 0x0B, 0x0A, 
    0x0B, 0x06, 0x02, 0x06, 0x07, 0x04, 
    
    // font data
    0x1C, 0x3E, 0xFE, 0x7E, 0x1C, 0x08, 0x1C, 0x1C, 0x1C, 0x08, // 33
    0x3E, 0x3E, 0x00, 0x3E, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, // 34
    0x90, 0x90, 0xFE, 0xFE, 0xFE, 0x90, 0xD0, 0xBE, 0x90, 0x00, 0x1E, 0x1E, 0x1E, 0x00, 0x00, 0x1E, 0x00, 0x00, // 35
    0x3C, 0x7C, 0xFE, 0xFE, 0xF2, 0xFE, 0xC3, 0x84, 0x08, 0x28, 0x1C, 0x16, 0x1E, 0x1E, 0x0E, 0x0E, // 36
    0x3C, 0x7E, 0x7E, 0x42, 0x3C, 0x80, 0x60, 0x98, 0xC6, 0xC0, 0x40, 0x80, 0x00, 0x00, 0x00, 0x10, 0x0C, 0x02, 0x00, 0x0E, 0x1E, 0x1E, 0x10, 0x0E, // 37
    0x00, 0xBC, 0x7C, 0xFE, 0xFA, 0xF2, 0xF2, 0xCC, 0x00, 0x80, 0x40, 0x40, 0x0E, 0x18, 0x10, 0x12, 0x16, 0x0E, 0x1E, 0x1E, 0x1E, 0x1C, 0x18, 0x10, // 38
    0x3E, 0x3E, 0x00, 0x00, // 39
    0xF8, 0xFC, 0xFE, 0x02, 0x1E, 0x3E, 0x7E, 0x40, // 40
    0x02, 0xFE, 0xFC, 0xF8, 0x40, 0x7E, 0x3E, 0x1E, // 41
    0x04, 0x3C, 0x1E, 0x2C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, // 42
    0x80, 0x80, 0x80, 0xF0, 0xF0, 0xF0, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x0E, 0x0E, 0x0E, 0x00, 0x00, 0x00, // 43
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x5C, 0x5C, 0x6C, 0x38, // 44
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 45
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1C, 0x1C, 0x1C, 0x08, // 46
    0x00, 0x00, 0x00, 0xC0, 0x30, 0x0C, 0x02, 0x60, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00, // 47
    0xF0, 0xFC, 0xFE, 0xFE, 0xFE, 0x02, 0x0C, 0xF0, 0x02, 0x0E, 0x1E, 0x1E, 0x1E, 0x10, 0x0C, 0x02, // 48
    0x08, 0x08, 0xFC, 0xFC, 0xFC, 0xFE, 0xFE, 0x00, 0x00, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, // 49
    0x38, 0x04, 0x02, 0xC2, 0xF2, 0xFE, 0xFE, 0x7C, 0x38, 0x10, 0x18, 0x1E, 0x1E, 0x1E, 0x1E, 0x12, 0x10, 0x10, // 50
    0x00, 0x04, 0x02, 0x22, 0xFE, 0xDE, 0xDE, 0xDC, 0x80, 0x08, 0x10, 0x10, 0x10, 0x1E, 0x1E, 0x1E, 0x0E, 0x06, // 51
    0x00, 0x00, 0x80, 0x40, 0xE0, 0xF0, 0xF8, 0xFC, 0xFE, 0x00, 0x04, 0x06, 0x04, 0x04, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x04, // 52
    0xC0, 0x08, 0x0E, 0x0A, 0xFA, 0xFA, 0xF2, 0xF2, 0xE0, 0x06, 0x08, 0x10, 0x10, 0x1E, 0x1E, 0x1E, 0x0E, 0x02, // 53
    0xF0, 0xFC, 0xFC, 0xFE, 0xFE, 0x22, 0x24, 0xC0, 0x02, 0x0E, 0x1E, 0x1E, 0x1E, 0x10, 0x08, 0x06, // 54
    0x02, 0x02, 0x02, 0x82, 0xE2, 0xFA, 0xFE, 0xFE, 0x3E, 0x06, 0x00, 0x10, 0x1C, 0x1E, 0x1E, 0x1E, 0x1E, 0x02, 0x00, 0x00, // 55
    0x38, 0xFC, 0xFE, 0xFE, 0xF2, 0xE2, 0xFC, 0xC0, 0x0E, 0x10, 0x10, 0x12, 0x1A, 0x1E, 0x0E, 0x06, // 56
    0x78, 0x84, 0x82, 0xFE, 0xFE, 0xFE, 0xFC, 0xF0, 0x00, 0x08, 0x10, 0x1E, 0x1E, 0x0E, 0x0E, 0x02, // 57
    0x20, 0x70, 0x70, 0x70, 0x20, 0x08, 0x1C, 0x1C, 0x1C, 0x08, // 58
    0x20, 0x70, 0x70, 0x70, 0x20, 0x18, 0x5C, 0x5C, 0x6C, 0x38, // 59
    0x40, 0x60, 0xE0, 0xF0, 0xD0, 0x88, 0x8C, 0x00, 0x00, 0x00, 0x02, 0x02, 0x06, 0x0E, // 60
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, // 61
    0x3C, 0x38, 0x70, 0xF0, 0xE0, 0xC0, 0x40, 0x0C, 0x04, 0x02, 0x02, 0x00, 0x00, 0x00, // 62
    0x0C, 0x04, 0x02, 0xFE, 0x7E, 0x7E, 0x3C, 0x3C, 0x00, 0x08, 0x1C, 0x1C, 0x1C, 0x08, 0x00, 0x00, // 63
    0xF0, 0x08, 0xE4, 0xF6, 0x12, 0xD2, 0xF2, 0xF2, 0x04, 0x8C, 0xF0, 0x02, 0x06, 0x08, 0x1A, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0A, 0x00, // 64
    0x00, 0x00, 0x00, 0xC0, 0x70, 0xF8, 0xFE, 0xF8, 0xF0, 0xC0, 0x00, 0x00, 0x00, 0x10, 0x0C, 0x0A, 0x08, 0x08, 0x0A, 0x0E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1C, 0x10, // 65
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x02, 0x82, 0x84, 0x78, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x10, 0x10, 0x1A, 0x0E, // 66
    0xF0, 0xF8, 0xFC, 0xFE, 0xFE, 0x02, 0x02, 0x02, 0x04, 0x08, 0x02, 0x06, 0x0E, 0x1E, 0x1E, 0x10, 0x10, 0x08, 0x0C, 0x02, // 67
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x02, 0x02, 0x04, 0x08, 0xF0, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x10, 0x10, 0x08, 0x04, 0x02, // 68
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x12, 0x12, 0x12, 0x12, 0x12, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x10, 0x10, 0x10, 0x10, 0x10, // 69
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x12, 0x12, 0x12, 0x12, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x00, 0x00, 0x00, 0x00, // 70
    0xF0, 0xF8, 0xFC, 0xFE, 0xFE, 0x02, 0x42, 0x44, 0x48, 0xC0, 0x02, 0x06, 0x0E, 0x1E, 0x1E, 0x10, 0x10, 0x08, 0x04, 0x02, // 71
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x20, 0x20, 0x20, 0x20, 0xFE, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x1E, // 72
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, // 73
    0x00, 0x00, 0x00, 0x00, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x0C, 0x08, 0x10, 0x10, 0x1E, 0x1E, 0x1E, 0x0E, 0x06, // 74
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x08, 0x0C, 0x34, 0xC2, 0x02, 0x00, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x06, 0x18, // 75
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x10, 0x10, 0x10, 0x10, 0x10, // 76
    0x00, 0x80, 0xF0, 0xFE, 0xFC, 0xF8, 0xF0, 0xC0, 0xE0, 0xF0, 0xFC, 0xFE, 0xF0, 0x80, 0x00, 0x18, 0x06, 0x00, 0x02, 0x06, 0x0E, 0x06, 0x00, 0x00, 0x0E, 0x1E, 0x1E, 0x1E, 0x1E, 0x18, // 77
    0xFE, 0x7C, 0xFC, 0xF8, 0xF8, 0xF0, 0xF0, 0xE0, 0xC0, 0xFE, 0x1E, 0x00, 0x00, 0x00, 0x02, 0x06, 0x06, 0x0E, 0x0E, 0x1E, // 78
    0xF0, 0xF8, 0xFC, 0xFE, 0xFE, 0x02, 0x02, 0x04, 0x08, 0xF0, 0x02, 0x06, 0x0E, 0x1E, 0x1E, 0x10, 0x10, 0x08, 0x04, 0x02, // 79
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x02, 0x02, 0x04, 0x0C, 0xF0, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x04, 0x04, 0x04, 0x02, 0x00, // 80
    0xF0, 0xF8, 0xFC, 0xFE, 0xFE, 0x02, 0x02, 0x04, 0x08, 0xF0, 0x02, 0x06, 0x0E, 0x1E, 0x1E, 0x10, 0x14, 0x18, 0x1C, 0x22, // 81
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x02, 0x02, 0x04, 0x8C, 0xF0, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x02, 0x0C, 0x1C, 0x12, 0x00, // 82
    0x38, 0x7C, 0xFE, 0xFE, 0xFA, 0xE2, 0xC4, 0x80, 0x08, 0x10, 0x10, 0x16, 0x1E, 0x1E, 0x0E, 0x06, // 83
    0x02, 0x02, 0x02, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x00, 0x00, 0x00, // 84
    0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x06, 0x0E, 0x1E, 0x1E, 0x1E, 0x10, 0x10, 0x10, 0x08, 0x06, // 85
    0x02, 0x0E, 0x1E, 0x7E, 0xFE, 0xFE, 0xFC, 0xF0, 0xC0, 0x60, 0x10, 0x0C, 0x02, 0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x1E, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, // 86
    0x02, 0x1E, 0xFE, 0xFE, 0xFE, 0xFE, 0xF0, 0xC0, 0xF0, 0xF8, 0xFE, 0xF8, 0xF0, 0xE0, 0x18, 0x06, 0x00, 0x00, 0x00, 0x06, 0x3E, 0x0E, 0x06, 0x00, 0x00, 0x06, 0x0E, 0x3E, 0x06, 0x00, 0x00, 0x00, // 87
    0x02, 0x0E, 0x1E, 0xFE, 0xFE, 0xFE, 0xFC, 0xF0, 0xD8, 0x04, 0x02, 0x00, 0x10, 0x08, 0x06, 0x00, 0x02, 0x06, 0x1E, 0x1E, 0x1E, 0x1E, 0x1C, 0x10, // 88
    0x02, 0x06, 0x0E, 0x3E, 0x7E, 0xFE, 0xFC, 0xF8, 0x30, 0x10, 0x0C, 0x02, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0C, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, // 89
    0x00, 0x02, 0x82, 0xE2, 0xFA, 0xFE, 0xFE, 0xFE, 0x3E, 0x0E, 0x02, 0x10, 0x1C, 0x1E, 0x1E, 0x1E, 0x1E, 0x16, 0x10, 0x10, 0x10, 0x10, // 90
    0xFE, 0xFE, 0xFE, 0x02, 0x02, 0x7E, 0x7E, 0x7E, 0x40, 0x40, // 91
    0x02, 0x0C, 0x30, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0C, 0x10, // 92
    0x02, 0x02, 0xFE, 0xFE, 0xFE, 0x40, 0x40, 0x7E, 0x7E, 0x7E, // 93
    0xC0, 0xF0, 0xF8, 0x3E, 0x1C, 0x30, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 94
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, // 95
    0x02, 0x06, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00, // 96
    0x80, 0xD0, 0xC8, 0xC8, 0x48, 0xF8, 0xF8, 0xF8, 0xF0, 0x0E, 0x1E, 0x1E, 0x1E, 0x10, 0x1E, 0x1E, 0x1E, 0x1E, // 97
    0xFE, 0xFE, 0xFE, 0xFE, 0x10, 0x08, 0xF8, 0xF8, 0xF0, 0xE0, 0x1E, 0x1E, 0x1E, 0x1E, 0x08, 0x10, 0x1E, 0x1E, 0x0E, 0x06, // 98
    0xE0, 0xF0, 0xF8, 0xF8, 0x08, 0x18, 0x30, 0x06, 0x0E, 0x1E, 0x1E, 0x10, 0x08, 0x04, // 99
    0xE0, 0xF0, 0xF8, 0xF8, 0x08, 0x10, 0xFE, 0xFE, 0xFE, 0xFE, 0x06, 0x0E, 0x1E, 0x1E, 0x10, 0x08, 0x1E, 0x1E, 0x1E, 0x1E, // 100
    0xE0, 0xF0, 0xF8, 0xF8, 0x88, 0xF8, 0xF0, 0xE0, 0x06, 0x0E, 0x1E, 0x1E, 0x10, 0x10, 0x08, 0x04, // 101
    0x08, 0xFE, 0xFE, 0xFF, 0xFF, 0x09, 0x00, 0x1E, 0x1E, 0x1E, 0x1E, 0x00, // 102
    0xE0, 0xF0, 0xF8, 0x08, 0xF8, 0xF4, 0xE0, 0x1A, 0x1E, 0x1E, 0x1C, 0x1E, 0x3A, 0x38, // 103
    0xFE, 0xFE, 0xFE, 0xFE, 0x10, 0x08, 0xF8, 0xF8, 0xF8, 0xF0, 0x1E, 0x1E, 0x1E, 0x1E, 0x00, 0x00, 0x1E, 0x1E, 0x1E, 0x1E, // 104
    0xFB, 0xFB, 0xFB, 0xFB, 0x1E, 0x1E, 0x1E, 0x1E, // 105
    0x00, 0xFB, 0xFB, 0xFB, 0xFB, 0x20, 0x3E, 0x3E, 0x3E, 0x0E, // 106
    0xFE, 0xFE, 0xFE, 0xFE, 0xC0, 0xE0, 0xF0, 0xF0, 0x88, 0x08, 0x00, 0x1E, 0x1E, 0x1E, 0x1E, 0x00, 0x02, 0x0E, 0x1E, 0x1E, 0x1E, 0x18, // 107
    0xFE, 0xFE, 0xFE, 0xFE, 0x1E, 0x1E, 0x1E, 0x1E, // 108
    0xF8, 0xF8, 0xF8, 0xF8, 0x10, 0x08, 0xF8, 0xF8, 0xF8, 0xF0, 0x10, 0x08, 0xF8, 0xF8, 0xF8, 0xF0, 0x1E, 0x1E, 0x1E, 0x1E, 0x00, 0x00, 0x1E, 0x1E, 0x1E, 0x1E, 0x00, 0x00, 0x1E, 0x1E, 0x1E, 0x1E, // 109
    0xF8, 0xF8, 0xF8, 0xF8, 0x10, 0x08, 0xF8, 0xF8, 0xF8, 0xF0, 0x1E, 0x1E, 0x1E, 0x1E, 0x00, 0x00, 0x1E, 0x1E, 0x1E, 0x1E, // 110
    0xE0, 0xF0, 0xF8, 0xF8, 0x08, 0x08, 0x10, 0xE0, 0x06, 0x0E, 0x1E, 0x1E, 0x10, 0x10, 0x08, 0x06, // 111
    0xF8, 0xF8, 0xF8, 0xF8, 0x10, 0x08, 0xF8, 0xF8, 0xF0, 0xE0, 0x3E, 0x3E, 0x3E, 0x3E, 0x04, 0x08, 0x0E, 0x0E, 0x06, 0x02, // 112
    0xE0, 0xF0, 0xF8, 0xF8, 0x08, 0x10, 0xF8, 0xF8, 0xF8, 0xF8, 0x06, 0x0E, 0x1E, 0x1E, 0x10, 0x08, 0x3E, 0x3E, 0x3E, 0x3E, // 113
    0xF8, 0xF8, 0xF8, 0xF8, 0x10, 0x08, 0x08, 0x1E, 0x1E, 0x1E, 0x1E, 0x00, 0x00, 0x00, // 114
    0x70, 0xF0, 0xF8, 0xE8, 0xC8, 0xC8, 0x98, 0x10, 0x08, 0x18, 0x12, 0x12, 0x16, 0x1E, 0x0E, 0x0E, // 115
    0x08, 0xFC, 0xFC, 0xFE, 0xFE, 0x08, 0x08, 0x00, 0x0E, 0x1E, 0x1E, 0x1E, 0x18, 0x0C, // 116
    0xF8, 0xF8, 0xF8, 0xF8, 0x00, 0x00, 0xF8, 0xF8, 0xF8, 0xF8, 0x0E, 0x1E, 0x1E, 0x1E, 0x10, 0x10, 0x1E, 0x1E, 0x1E, 0x1E, // 117
    0x08, 0x18, 0x78, 0xF8, 0xF8, 0xE0, 0xC0, 0xC0, 0x30, 0x08, 0x00, 0x00, 0x00, 0x02, 0x06, 0x1E, 0x06, 0x00, 0x00, 0x00, // 118
    0x08, 0x38, 0xF8, 0xF8, 0xF8, 0xE0, 0x80, 0xC0, 0xF0, 0xF8, 0xF0, 0xC0, 0x60, 0x18, 0x00, 0x00, 0x00, 0x06, 0x1E, 0x0E, 0x02, 0x00, 0x02, 0x0E, 0x1E, 0x02, 0x00, 0x00, // 119
    0x08, 0x18, 0x38, 0xF8, 0xF8, 0xF0, 0xC0, 0xA0, 0x10, 0x08, 0x00, 0x10, 0x08, 0x04, 0x02, 0x02, 0x0E, 0x1E, 0x1E, 0x1C, 0x18, 0x10, // 120
    0x08, 0x18, 0x38, 0xF8, 0xF8, 0xF0, 0xC0, 0x40, 0x30, 0x08, 0x00, 0x00, 0x10, 0x10, 0x12, 0x0E, 0x02, 0x00, 0x00, 0x00, // 121
    0x00, 0x08, 0x08, 0x88, 0xC8, 0xE8, 0xF8, 0xF8, 0x78, 0x18, 0x08, 0x10, 0x18, 0x1C, 0x1E, 0x1E, 0x1E, 0x12, 0x10, 0x10, 0x10, 0x10, // 122
    0x80, 0x7C, 0x7E, 0x7E, 0x02, 0x02, 0x00, 0x3E, 0x7E, 0x7E, 0x40, 0x40, // 123
    0xFE, 0xFE, 0xFE, 0xFE, // 124
    0x02, 0x02, 0x7E, 0x7E, 0x7C, 0x80, 0x40, 0x40, 0x7E, 0x7E, 0x3E, 0x00, // 125
    0x80, 0x60, 0x60, 0xE0, 0xC0, 0xC0, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 126
    0xFE, 0x02, 0x02, 0xFE, 0x1E, 0x10, 0x10, 0x1E // 127
    
};

#endif
